% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program ROCanalysis.m

%%% Program ROCanalysis.m
function ROC = ROCanalysis(Srating, Nrating);
freqHits(1) = Srating(6); 
freqFA(1) = Nrating(6);
for i = 2:6
    freqHits(i) = freqHits(i-1) + Srating(7-i);
    freqFA(i) = freqFA(i-1) + Nrating(7-i);
end
                
pHits = freqHits(1:5)/freqHits(6);
pFA = freqFA(1:5)/freqFA(6);

figure;
plot(pFA, pHits, 'ks', pFA, pHits, 'k-');
line([0 1], [0 1]);
axis('square');
zHits = norminv(pHits);
zFA = norminv(pFA);

figure;
plot(zFA, zHits, 'ks', zFA, zHits, 'k-');
line([-3 3], [-3 3]);
axis([-3 3 -3 3]);
axis('square');

data = [zHits; zFA];
guess = [1 1.5 -2 -1 0 1 2];
options = optimset('fminsearch');
ROC = fminsearch('costfunc', guess, options, data);
d = ROC(1);  s1=1;
s2  = ROC(2);
c = ROC(3:7);

x = (-500:750)/100;
y1 = normpdf(x, 0, s1);
y2 = normpdf(x, d, s2);
figure;     % plot of the S+N and N distributions and 
            % criteria
plot(x, y1, 'k-', x, y2, 'k-'); hold on;
for i = 1:5
  x = [c(i) c(i)]; 
y = [0 0.2];
line(x, y);
end

% Cmpute the area under the ROC vurve
Y = [0 pHits 1];
X = [0 pFA 1];
A = 0;
for i = 2:7
    A = A + (X(i) - X(i-1))*(Y(i) + Y(i-1))/2;
end

ROC = [ROC A];
